/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.ladysnake.blabber.impl.common.model.StateType;

public sealed interface ValidationResult {
    public static Success success() {
        return Success.INSTANCE;
    }

    public static final class Success
    implements ValidationResult {
        public static final Success INSTANCE = new Success();
    }

    public static sealed interface Error
    extends ValidationResult {
        public String state();

        public String message();

        public record InvalidIllustratedState(String state, StateType type, List<String> illustrations) implements Error
        {
            @Override
            public String message() {
                return this.state() + " of type " + String.valueOf((Object)this.type) + " is not allowed to use illustrations " + String.valueOf(this.illustrations());
            }
        }

        public record NonexistentIllustration(String state, String illustration) implements Error
        {
            @Override
            public String message() {
                return this.state() + " references non-existent illustration " + this.illustration();
            }
        }

        public record SoftLock(String state) implements Error
        {
            @Override
            public String message() {
                return this.state() + " does not have any path to the end of the dialogue";
            }
        }

        public record NoChoice(String state) implements Error
        {
            @Override
            public String message() {
                return this.state() + " has no available choices but is not an end state";
            }
        }
    }

    public static sealed interface Warning {
        public String state();

        public String message();

        public record ConditionalSoftLock(String state) implements Warning
        {
            @Override
            public String message() {
                return this.state() + " only has conditional paths to the end of the dialogue";
            }
        }

        public record Unreachable(String state) implements Warning
        {
            @Override
            public String message() {
                return this.state() + " is unreachable";
            }
        }
    }

    public record Warnings(List<Warning> warnings) implements ValidationResult
    {
        public String message() {
            return this.warnings().stream().map(Warning::message).collect(Collectors.joining(", "));
        }
    }
}

